# Classical Nyx vs QAOA - QIP 2026 Verification Package

This package allows independent verification of the QIP 2026 rump session claim:

**"Classical Nyx running on a laptop outperforms quantum QAOA on standard optimization problems."**

## Quick Start

```bash
# Install requirements
pip install numpy cython

# Compile
python setup.py build_ext --inplace

# Run
python classical_nyx_vs_qaoa.py
```

## What This Tests

| Problem | Description | Optimal Value |
|---------|-------------|---------------|
| Max-Cut | Graph partitioning | 19 |
| Portfolio | Asset selection | 0.15 |
| Set Cover | Minimum cover | 2 sets |
| Knapsack | Value maximization | 25 |

## Verifying QAOA Results

All QAOA baselines come from IBM Quantum hardware (January 22, 2026). To verify:

1. Go to https://quantum.ibm.com
2. Sign in with your IBM Quantum account
3. Navigate to Workloads > Jobs
4. Enter any Job ID from the test output
5. View measurement results

### QAOA Job IDs

**ibm_torino (133 qubits):**
- Max-Cut: `d5pab0gr0v5s739nmtog`
- Portfolio: `d5pac1oh0i0s73ep07d0`
- Set Cover: `d5pacgu5v3os73f1och0`
- Knapsack: `d5pack65v3os73f1oclg`

**ibm_fez (156 qubits):**
- Max-Cut: `d5pacngr0v5s739nmvlg`
- Portfolio: `d5pacqu5v3os73f1od00`
- Set Cover: `d5pacu0r0v5s739nn00g`
- Knapsack: `d5pad1e5v3os73f1od8g`

**ibm_marrakesh (156 qubits):**
- Max-Cut: `d5pad50h0i0s73ep08o0`
- Portfolio: `d5paj3gh0i0s73ep0fr0`
- Set Cover: `d5pan3pdgvjs73dbg30g`
- Knapsack: `d5papo65v3os73f1ot4g`

## Files

| File | Description |
|------|-------------|
| `classical_nyx_vs_qaoa.py` | Main test script |
| `nyx_core.pyx` | Nyx dynamics (Cython source) |
| `setup.py` | Build script |

## Requirements

- Python 3.8+
- NumPy
- Cython

## Running the Test

Results will vary slightly due to stochastic sampling. Run multiple times to verify consistency.

## Contact

research@subvurs.com

## License

Research use only. Contact for commercial licensing.
