from setuptools import setup, find_packages
try:
    from Cython.Build import cythonize
    import numpy as np
    USE_CYTHON = True
except ImportError:
    USE_CYTHON = False

ext_modules = []
if USE_CYTHON:
    ext_modules = cythonize(
        "hive_keyboard/hive_engine.pyx",
        compiler_directives={'language_level': "3"}
    )

setup(
    name="hive-keyboard",
    version="0.2.0",
    description="Deterministic Quantum State Addressing via Topological Permutations",
    long_description=open("README.md").read() if __import__("os").path.exists("README.md") else "",
    long_description_content_type="text/markdown",
    author="Claude-Gemini Collaboration",
    author_email="research@subvurs.org",
    url="https://github.com/subvurs/hive-keyboard",
    packages=find_packages(),
    ext_modules=ext_modules,
    include_dirs=[np.get_include()] if USE_CYTHON else [],
    include_package_data=True,
    python_requires=">=3.9",
    install_requires=[
        "qiskit>=1.0.0",
        "qiskit-aer>=0.13.0",
        "numpy>=1.20.0",
        "networkx>=2.6.0",
    ],
    extras_require={
        "hardware": [
            "qiskit-ibm-runtime>=0.20.0",
        ],
        "mitigation": [
            "qiskit-ibm-runtime>=0.20.0",
            "mthree>=2.0.0",
        ],
        "full": [
            "qiskit-ibm-runtime>=0.20.0",
            "mthree>=2.0.0",
            "networkx>=2.6.0",
        ],
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
        ],
    },
    package_data={
        "hive_keyboard": ["maps/*.json"],
    },
    entry_points={
        "console_scripts": [
            "hive-keyboard=hive_keyboard.cli:main",
        ],
    },
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Scientific/Engineering :: Physics",
        "Topic :: Scientific/Engineering :: Information Analysis",
    ],
    keywords="quantum computing, quantum circuits, deterministic addressing, qiskit",
)
